;*******************************
;*    DEMONTRATION PROGRAM 3   *
;*            RELAY            *
;*******************************
;
            ORG    8000H
DIPSW       EQU    0E0A0H
U21PA       EQU    0E0B8H
U21PB       EQU    0E0B9H
U21PC       EQU    0E0BAH
U21CTRL     EQU    0E0BBH
U28PA       EQU    0E0B4H
U28PB       EQU    0E0B5H
U28PC       EQU    0E0B6H
U28CTRL     EQU    0E0B7H
SEG_PORT    EQU    U21PB
SCAN_KYDP   EQU    27H
CLRSCR      EQU    7               ;System call
HI_BEEP     EQU    18H             ;   "     "
ONE_TO_TWO  EQU    1DH             ;   "     "
WAIT_2KEY   EQU    33H             ;   "     "
RLY_PORT    EQU    22H             ;Port buffer of relay
RELAY_NUM   EQU    RLY_PORT+1
SYSCALL     EQU    0030H
DISBUF      EQU    9F00H

DEM31:      MOV    DPTR,#U28CTRL
            MOV    P2,DPH
            MOV    A,#81H
            MOVX   @DPTR,A
            MOV    DPTR,#U28PA
            MOV    R1,DPL           ;Relay port
            MOV    A,#0FFH
            MOVX   @DPTR,A
            INC    DPTR
            CLR    A
            MOVX   @DPTR,A
            MOV    RLY_PORT,A
            MOV    RELAY_NUM,A

START:      MOV    A,#CLRSCR        ;Clear screen
            LCALL  SYSCALL
            LCALL  PRINT
            ;Text "On-OFF"
            DB     3FH,54H,40H,3FH,71H,71H,00
WAIT_KEY:   MOV    A,#SCAN_KYDP
            LCALL  SYSCALL
            CJNE   A,#13H,CP11
            SJMP   RELAY_ON
CP11:       CJNE   A,#11H,WAIT_KEY
RELAY_OFF:  LCALL  PRINT
            DB     20H,20H,40H,3FH,71H,71H,00  ;"  -OFF"
            MOV    B,RELAY_NUM
            MOV    A,#ONE_TO_TWO
            LCALL  SYSCALL
            MOV    DPTR,#DISBUF
            MOVX   @DPTR,A
            INC    DPTR
            MOV    A,B
            MOVX   @DPTR,A
            MOV    A,#HI_BEEP
            LCALL  SYSCALL

R_OFF1:     MOV    DPTR,#DISBUF
            MOV    A,#WAIT_2KEY
            LCALL  SYSCALL
            CJNE   A,#9,R_OFF2
R_OFF2:     JNC    R_OFF1
            JZ     R_OFF1            ;Require 1-4
            XCH    A,B               ;Save Channel of relay
            CJNE   A,#13H,R_OFF1     ;Not instance key
            MOV    A,B
            MOV    RELAY_NUM,A
            DEC    A
            MOV    DPTR,#RELAY_TAB
            MOVC   A,@A+DPTR
            CPL    A
            ANL    A,RLY_PORT
            MOV    RLY_PORT,A
            CPL    A
            MOVX   @R1,A                   ;Output relay port
            SJMP   START

RELAY_TAB:  DB     01,02
            DB     04,08
            DB     10H,20H
            DB     40H,80H

RELAY_ON:   LCALL  PRINT
            DB     20H,20H,20H,40H,3FH,54H,00  ;"   -O"
            MOV    B,RELAY_NUM
            MOV    A,#ONE_TO_TWO
            LCALL  SYSCALL
            MOV    DPTR,#DISBUF+1
            MOVX   @DPTR,A
            INC    DPTR
            MOV    A,B
            MOVX   @DPTR,A
            MOV    A,#HI_BEEP
            LCALL  SYSCALL
R_ON1:      MOV    DPTR,#DISBUF+1
            MOV    A,#WAIT_2KEY
            LCALL  SYSCALL
            CJNE   A,#9,R_ON2
R_ON2:      JNC    R_ON1
            JZ     R_ON1                   ;Require 1-4
            XCH    A,B
            CJNE   A,#13H,R_ON1            ;Not instance key
            MOV    A,B                     ;Channel of relay
            MOV    RELAY_NUM,A
            DEC    A
            MOV    DPTR,#RELAY_TAB
            MOVC   A,@A+DPTR
            ORL    A,RLY_PORT
            MOV    RLY_PORT,A
            CPL    A
            MOVX   @R1,A                   ;Output relay port
            LJMP   START

;*****************************************
;*  Move data following "CALL PRINT_DSP" *
;*  to display buffer.                   *
;*  Usage: LCALL PRINT_DSP               *
;*         DB   'xxxx',00                *
;*  Register : R0                        *
;*  Note : End of text by fill to end 00 *
;*         Space on disply by code 20h.  *
;*****************************************
;
PRINT:      MOV    DPTR,#DISBUF
            MOV    P2,DPH
            MOV    R0,DPL         ;P2:R0 = Destination
            POP    DPH            ;Point to data to print
            POP    DPL
PRNTD1:     CLR    A
            MOVC   A,@A+DPTR
            JZ     END_PRN        ;End of text
            CJNE   A,#20H,PRNTD2
            CLR    A
PRNTD2:     MOVX   @R0,A          ;Write to display buffer
            INC    DPTR
            INC    R0
            SJMP   PRNTD1
END_PRN:    JMP    @A+DPTR        ;Return
            ;End of print
            ;Return to main


            END

